# Reactive Programing: event streams

## Outline

### Objective

* Understand how to manage a stream of events
* Use this tech to manage our messenger

### Technologies used

* Javascript
* RX

### Design Patterns

* FRP (Functional Reactive Programing)

### What we will do

* Solve exercises in FRP for managing data
* apply this knowledge to our messenger application

## Pre Session

## Session

Read this [Intro to FRP](https://gist.github.com/staltz/868e7e9bc2a7b8c1f754)

Complete [This exercise set](http://reactivex.io/learnrx/)
You will find the repo of the online exercise about [here](https://github.com/ReactiveX/learnrx)

### Additional resources

Complete [this animated intro to RxJS](https://css-tricks.com/animated-intro-rxjs/)


## Assignment

Implement your own Observable and stream library

create 2 files one is the observable the other is a test of its functionality

our Observable acts like a promise library

You can create an observable stream in 2 ways
```js
let stream$ = new Observable((next, err, complete=> {

}))
// create a stream with and push [1, 2, 3] in it
let stream$ = new Observable([1, 2, 3], (next, err, complete=> {

}))
```
Where `next` is a function  that wraps our default push function your push function

The way our observable works is that it acts like a black box with abstractly 2 methods


**Stream.subscribe(subscriberCallback)**
> A function that adds subscribers to the Observable stream and notifies them  whenever an element is pushed
> returns the stream

**Stream.push(element)**
> A function that inputs by default an element into the stream updating the subscribers
> the next function we define in the constructor replaces this function
> returns the stream


```js
let stream$ = Observable([1, 2, 3])
stream$.subscribe(el=> {
  console.log(el);
})
// prints 1
// prints 2
// prints 3
stream$.push(4)
// prints 4
```

**Observable.map(Stream, nextFn)**
> A function that takes a stream and a function and returns another stream
> that is subscribed to the input Stream and nextFn as it's push function

```js
let stream$ = Observable([1, 2, 3])
stream$.subscribe(el=> {
  console.log(el);
})
// prints 1
// prints 2
// prints 3
let mappedStream$ = Observable.map(stream$, el=> el*2)
mappedStream$.subscribe(el=> {
  console.log('mappedStream', el);
})
// prints mappedStream 2
// prints mappedStream 4
// prints mappedStream 6
stream$.push(4)
// prints 4
// prints mappedStream 8
```

do for map, reduce, filter, zip, throttle, buffer

### Bonus

Use the observable in your existing app (2 points)
